#include <iostream>
#include <vector>
#include <set>
#include <deque>
#include <stack>
#include <queue>
#include <map>
#include <unordered_map>
#include <unordered_set>
#include <iomanip>
#include <random>
#include <algorithm>
#include <cmath>
#include <fstream>

using namespace std;

typedef long long ll;
typedef long double dl;

ll power(ll a, ll p, ll mod)
{
	if (a == 0) return 1;
	if (a == 1) return a;
	ll d = power(a, p / 2, mod);
	if (p & 1) return ((d * d) % mod * a) % mod;
	return (d * d) % mod;
}
ll gcd(ll a, ll b)
{
	if (a == 0 || b == 0) return a + b;
	if (a > b) return gcd(a % b, b);
	return gcd(a, b % a);
}
ll get_hash(ll l, ll r, vector <ll>& h, vector <ll>& p, ll mod)
{
	return ((h[r + 1] - p[r - l + 1] * h[l]) % mod + mod) % mod;
}
ll find(ll v, vector <ll>& p)
{
	if (p[v] == v) return v;
	return p[v] = find(p[v], p);
}
void union_s(ll a, ll b, vector <ll>& p, vector <ll>& sz)
{
	a = find(a, p);
	b = find(b, p);
	if (a != b)
	{
		if (sz[a] < sz[b]) swap(a, b);
		p[b] = a;
		sz[a] += sz[b];
	}
}
ll timer = 0;
void dfs(ll v, ll prev, vector <ll>& tin, vector <ll>& tout, vector <vector <ll>>& up, vector <vector <ll>>& g)
{
	tin[v] = timer++;
	up[0][v] = prev;
	for (ll i = 1; i < up.size(); i++)
	{
		up[i][v] = up[i - 1][up[i - 1][v]];
	}
	for (auto i : g[v])
	{
		if (i != prev)
		{
			dfs(i, v, tin, tout, up, g);
		}
	}
	tout[v] = timer++;
}
bool upper(ll a, ll b, vector <ll>& tin, vector <ll>& tout)
{
	return tin[a] <= tin[b] && tout[b] <= tout[a];
}
ll lca(ll a, ll b, vector <ll>& tin, vector <ll>& tout, vector <vector <ll>>& up)
{
	if (upper(a, b, tin, tout)) return a;
	if (upper(b, a, tin, tout)) return b;
	for (ll i = up.size() - 1; i >= 0; i--)
	{
		if (!upper(up[i][a], b, tin, tout))
		{
			a = up[i][a];
		}
	}
	return up[0][a];
}

struct node
{
	ll x1, y1, x2, y2;
};
dl eps = -1e-12;
bool per(node& a, node& b)
{
	if (a.x1 == b.x1 && a.y1 == b.y1) return true;
	if (a.x1 == b.x2 && a.y1 == b.y2) return true;
	if (a.x2 == b.x1 && a.y2 == b.y1) return true;
	if (a.x2 == b.x2 && a.y2 == b.y2) return true;
	ll a1 = a.y1 - a.y2, b1 = a.x2 - a.x1, c1 = a.x1 * a.y2 - a.x2 * a.y1;
	ll a2 = b.y1 - b.y2, b2 = b.x2 - b.x1, c2 = b.x1 * b.y2 - b.x2 * b.y1;
	if (a1 * b2 == a2 * b1) return false;
	dl x = ((dl)c2 * b1 - (dl)c1 * b2) / ((dl)a1 * b2 - (dl)a2 * b1), y;
	if (b1 == 0) y = -(x * a2 + c2) / b2;
	else y = -(x * a1 + c1) / b1;
	if (x - a.x1 >= eps && a.x2 - x >= eps && x - b.x1 >= eps && b.x2 - x >= eps && (y - a.y1 >= eps && a.y2 - y >= eps || a.y1 - y >= eps && y - a.y2 >= eps) && (y - b.y1 >= eps && b.y2 - y >= eps || b.y1 - y >= eps && y - b.y2 >= eps)) return true;
	return false;
}

int main()
{
	//ifstream cin("input.txt");
	//ofstream cout("output.txt");
	cin.tie(0);
	cout.tie(0);
	ios_base::sync_with_stdio(0);
	//random_device rd;
	//mt19937 gen(rd());
	
	/*ll mod = 998244353;
	ll t;
	cin >> t;
	while (t--)
	{
		ll n, m;
		cin >> n >> m;

	}*/

	ll t;
	cin >> t;
	while (t--)
	{
		ll n, ans = 0;
		cin >> n;
		vector <node> a(n);
		vector <ll> p(n), sz(n, 1);
		for (ll i = 0; i < n; i++) p[i] = i;
		for (ll i = 0; i < n; i++)
		{
			cin >> a[i].x1 >> a[i].y1 >> a[i].x2 >> a[i].y2;
			if (a[i].x2 < a[i].x1)
			{
				swap(a[i].x1, a[i].x2);
				swap(a[i].y1, a[i].y2);
			}
			unordered_set <ll> vis;
			vector <ll> t;
			for (ll j = 0; j < i; j++)
			{
				if (per(a[i], a[j]))
				{
					ll u = find(j, p);
					t.push_back(j);
					if (vis.find(u) == vis.end()) vis.insert(u);
					else ans++;
				}
			}
			for (auto j : t) union_s(i, j, p, sz);
		}
		cout << ans + 1 << "\n";
	}

	return 0;
}